/************************************************************ 
The contents of this file are subject to the Pumpkin Salvo
License (the "License").  You may not use this file except
in compliance with the License. You may obtain a copy of
the License at http://www.pumpkininc.com, or from
warranty@pumpkininc.com.

Software distributed under the License is distributed on an
"AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
or implied. See the License for specific language governing
the warranty and the rights and limitations under the
License.

The Original Code is Salvo - The RTOS that runs in tiny
places(TM). Copyright (C) 1995-2002 Pumpkin, Inc. and its
Licensor(s). All Rights Reserved.

Porting file for TI MSP430 and ImageCraft ICC430 C compiler. 

Updated 2005-06-07 to be compatible with ICC430 v6.06 and
higher ...

************************************************************/

#if OSMAKE_LIBRARY
#include <MSP430x14x.h>
#endif
#include <msp430def.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>


/* ICC430 C compiler passes parameters, return addresses,*/
/*  saved registers and auto variables on the stack, so */
/*  need to use the OSDispatch()+OSCtxSw() method.  	*/
#define OSCTXSW_METHOD					OSVIA_OSDISPATCH_WLABEL


/* SP is 16 bits                                        */
#define OSBYTES_OF_FRAMEP				2


/* conventional stack-based context-switcher, with the  */
/*  added requirement of a label due to indirect call   */
/*  requirements due to Code Compressor                 */
#define OS_Yield(label)                 do { OSCtxSw(label); \
                                             asm("_" _OSMkstr(label) "::"); \
                                        } while (0)


/* use ICC430's intrinsic functions.                     */
#if !defined(OSDi)
#define OSDi()   						_DINT()            
#endif
#if !defined(OSEi)
#define OSEi()      					_EINT()                    
#endif
  
          
/* ICC430 supports this keyword, but in a manner that   */
/*  does not allow a simple #pragma monitor in front of */
/*  each monitor function. See salvomcg.h on how this   */
/*  was handled. By defining this (as blank), the code  */
/*  is configured to let ICC430 handle int disable and  */
/*  restore on monitor functions.                       */
#define	OSMONITOR_KEYWORD_PRE			
#define	OSMONITOR_KEYWORD_PRE_PROTO			

 
/* should work fine. 									*/
#define OSUSE_MEMSET                    TRUE


/* printf() supports p (pointer) format. 				*/
#define OSUSE_PRINTF_P_FORMAT			TRUE


/* Watchdog reset                                       */
#define OSCLEAR_WATCHDOG_TIMER()        asm(" mov &0x120,R13  \n" \
                                            " and #0x00FF,R13 \n" \
                                            " add #0x5A08,R13 \n" \
                                            " mov R13,&0x120  \n")
                                            

/************************************************************ 
****                                                     ****
**                                                         **
Notes 

1. Since the instruction after the disabling of interrupts
is always executed, users are advised to add a nop (_NOP())
after OSDi() if the immediately following instruction must
be executed with interrupts disabled. 

2. ICC430 does not support bitfield packing (i.e. into
unsigned char instead of unsigned int). The high / "extra" 
byte in the status word contains the frame size (in words).

3. OSDispatch() and OSCtxSw() are in porticc430.s.

**                                                         **
****                                                     ****
************************************************************/
